
const screenArea = document.querySelector('.screen');
let preview;




// source switcher/graber component
// return the source (source/path) of source switcher
var selectedSource;
var userEntredPath;
let elem
let layerType
$('.source-switcher input').on('click', function () {

  elem = this.closest('.source-switcher')
  preview = elem.previousElementSibling


  function runPreview() {
    preview.innerHTML = ""

    if (preview.classList.contains('single-video-preview')) {
      preview.appendChild(createSingleVideoLayer())
      return selectedSource;

    } else if (preview.classList.contains('single-image-preview')) {
      preview.appendChild(createSingleImageLayer())
      return selectedSource;
    }
  }








  if (this.classList.contains('from-server')) {
    let selector = elem.nextElementSibling.childNodes[1]
    // show/hide the selector/input bar
    elem.nextElementSibling.style.display = 'block';
    selector.parentNode.nextElementSibling.style.display = 'none';


    selectedSource = selector.options[selector.selectedIndex].text;
    // grab source that user selected(from selector)
    selectedSourceGraber = function () {
      selectedSource = selector.options[selector.selectedIndex].text;

      runPreview()
      return selectedSource
    }

    // change listener for selector
    $(selector).on('change', function () {
      selectedSourceGraber()

    })

    runPreview()
    return selectedSourceGraber;

  } else if (this.classList.contains('by-path')) {
    // console.log('this',this.classList.contains('by-path'))
    // show/hide the input/selector bar
    elem.nextElementSibling.nextElementSibling.style.display = 'block';
    elem.nextElementSibling.style.display = 'none';

    // grab source that user added(from input)
    userEntredPath = elem.nextElementSibling.nextElementSibling.childNodes[1]
    selectedSource = userEntredPath.value

    $(userEntredPath).on('input', function () {
      selectedSource = this.value
      runPreview()
      return selectedSource;
    })

    runPreview()
    return selectedSource;
  }


})

// CreateLayer Single Image 
function createSingleImageLayer() {
  console.log('single image src:', selectedSource)

  let imageNode = document.createElement("img");
  imageNode.setAttribute("id", "layer" + Mark + '-image');
  imageNode.style = "transform': translate(23.9vw, 8.6vh"
  //imageNode.setAttribute('onmousedown',' selectClicked'+'('+'imageFullMark'+')')
  /* Binding image Source*/
  imageNode.setAttribute("src", selectedSource);

  Mark += 1;
  return imageNode;
}

// CreateLayer Single Video Layer
function createSingleVideoLayer() {

  // console.log('single video src:', selectedSource)
  let videoNode = document.createElement("video");

  videoNode.setAttribute("id", "layer" + Mark + '-video');
  videoNode.setAttribute('autoplay', 'true');
  videoNode.setAttribute('loop', 'true');

  /* Binding Video Source*/
  let videoSource = document.createElement("source");
  videoSource.setAttribute("src", selectedSource);
  videoSource.setAttribute("id", "video" + Mark);

  videoNode.appendChild(videoSource);

  Mark += 1;
  return videoNode;
}



$('.add-single-video-btn').on('click', function () {
  let videoLayer = createSingleVideoLayer()

  let videoWidth = document.querySelector('.single-video-width').value;
  let videoHeight = document.querySelector('.single-video-height').value;
  videoLayer.style.width = videoWidth + "%";
  videoLayer.style.height = videoHeight + "%";

  videoLayer.setAttribute("class", "resize-drag video");
  screenArea.appendChild(videoLayer);
  clearPreview()
})



$('.add-single-image-btn').on('click', function () {

  let imageLayer = createSingleImageLayer()

  let imageWidth = document.querySelector('.single-image-width').value;
  let imageHeight = document.querySelector('.single-image-height').value;
  imageLayer.style.width = imageWidth + "%";
  imageLayer.style.height = imageHeight + "%";


  imageLayer.setAttribute("class", "resize-drag image");
  screenArea.appendChild(imageLayer);
  clearPreview()
})



function clearPreview() {
  preview.innerHTML = '';
}






//Select and Delete layer
var activeLayerId;
// select active layer
window.onclick = e => {
  activeLayerId = e.target.id;
}
// delete layer by delete key
document.addEventListener('keydown', function (e) {
  if (e.key === 'Delete') {
    if (activeLayerId.includes('time')) {

      document.querySelector('#layer1-time').classList.replace('showClock', 'hideClock')
      document.querySelector('#layer2-time').classList.replace('showClock', 'hideClock')
      // document.querySelector('.timeAttr').classList.replace('show', 'hidden');



    } else if (activeLayerId.includes('layer')) {
      document.getElementById(activeLayerId).remove();
    }
  }
})





// Do somthing on modal open/close
// $('#modal-reserve').on('shown.bs.modal', function () {

// });
$('#modal-video').on('hidden.bs.modal', function () {
  // console.log('modal close')
  clearPreview()
});
$('#modal-single-image').on('hidden.bs.modal', function () {
  // console.log('modal close')
  clearPreview()
});
$('#myModal2').on('hidden.bs.modal', function () {
  // console.log('modal close')
  clearPreview()
});
// $('#myModal').on('hidden.bs.modal', function () {

// });


let contentEntered
document.querySelector('.add-content-btn').addEventListener('click', function () {

  contentEntered = CKEDITOR.instances.editor2.getData();
  // console.log('editor1',$('#editor1').val()) 



  let contentNodeEditor = document.createElement("div");
  contentNodeEditor.setAttribute("id", "layer" + Mark + '-content');
  contentNodeEditor.setAttribute("class", "editable resize-drag contentArea");

  // let textNode = document.createElement("p");
  contentNodeEditor.innerHTML = contentEntered
  // textNodeEditor.appendChild(textNode);
  document.querySelector('.screen').appendChild(contentNodeEditor);
  Mark += 1;


})




// $('.size-input').click(function () {

//   console.log($('.size-input').not(this))

// })




